import java.util.*;

public class DangoV2 {

    public static void main(String[] args) {
        Scanner in = new Scanner(System.in);

        int n = in.nextInt();
        int m = in.nextInt();

        Map<Character, Queue<Integer>> dishesMap = new HashMap<>();

        Dishes dishes = new Dishes(in.next().toCharArray());
        for (int i = 0; i < dishes.array.length; i++) {
            char dish = dishes.array[i];
            Queue<Integer> positions = dishesMap.computeIfAbsent(dish, k -> new PriorityQueue<>());
            positions.add(i);
        }

        for (int i = 0; i < m; i++) {
            int amount = in.nextInt();
            char dish = in.next(".").charAt(0);
            char newDish = in.next(".").charAt(0);
            for (int j = 0; j < amount; j++) {
                int position = dishesMap.get(dish).poll();
                dishesMap.getOrDefault(newDish, new PriorityQueue<>()).add(position);
            }
        }

        // 0123456789
        // babaabcbbc
        dishesMap.forEach((dish, positions) -> dishes.replace(positions, dish));
        System.out.println(dishes);
    }

    static class Dishes {
        final char[] array;

        Dishes(char[] array) {
            this.array = array;
        }

        void replace(Iterable<Integer> positions, char newDish) {
            for (Integer position : positions) {
                array[position] = newDish;
            }
        }

        @Override
        public String toString() {
            return new String(array);
        }
    }
}
